/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{
  public class CMainForm : Form
  {   
    Timer timer;    

    public CMainForm()
    {
      timer          = new Timer();
      timer.Tick    += new EventHandler( Timer_Tick );
      timer.Interval = 50;
      timer.Start();

      this.SetStyle(ControlStyles.UserPaint, true);
      this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
      this.SetStyle(ControlStyles.DoubleBuffer, true);
    } 

    void Timer_Tick( object sender, EventArgs e )
    {              
      this.Invalidate();
    }

    protected override void OnPaint( PaintEventArgs e )
    {
      Graphics g = e.Graphics;
      using ( Font f = new Font( "LED", 48 ) )
      {
        StringFormat sf  = new StringFormat();
        sf.Alignment     = StringAlignment.Center;
        sf.LineAlignment = StringAlignment.Center;

        g.Clear( SystemColors.Control );
        g.DrawString( DateTime.Now.ToLongTimeString(), f, Brushes.Black, 
                      this.Width / 2, this.Height / 2, sf );
      }
    }

    public static void Main()
    {
      Application.Run( new CMainForm() );
    }
  }
}

